/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.regionalsettings;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.insophy.inplan.util.regionalsettings.StrftimePatternConverter;
import cz.insophy.inplan.util.regionalsettings.XmlRegionalSettings;
import java.math.RoundingMode;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

public class FormatterRegionSettings {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final DateTimeFormatter shortDateFormat;
    private final DateTimeFormatter mediumDateFormat;
    private final DateTimeFormatter longDateFormat;
    private final DateTimeFormatter shortDatetimeFormat;
    private final DateTimeFormatter mediumDatetimeFormat;
    private final DateTimeFormatter longDatetimeFormat;
    private final DateTimeFormatter timeFormat;
    private final DateTimeFormatter fileDateFormat;
    private final DecimalFormat numberFormat;
    private final DecimalFormat percentFormat;
    private final DecimalFormat numberDurationFormat;
    private final XmlRegionalSettings.Region.Symbols symbols;
    private final String d3I18nJSON;
    private final String duDatePickerI18nJSON;
    private final Map<String, DateTimeFormatter> userDateFormat = new HashMap<String, DateTimeFormatter>();
    private final String mediumDateFormatPattern;
    private final String shortDatetimeFormatPattern;
    private final String longDateTimeFormatPattern;
    private final char decimalSeparator;

    public FormatterRegionSettings(@Nonnull XmlRegionalSettings.Region region) {
        this.shortDateFormat = DateTimeFormatter.ofPattern(region.getFormatPattern(XmlRegionalSettings.Region.FormatPattern.FormatType.SHORT_DATE), region.getLocale());
        this.mediumDateFormat = DateTimeFormatter.ofPattern(region.getFormatPattern(XmlRegionalSettings.Region.FormatPattern.FormatType.MEDIUM_DATE), region.getLocale());
        this.longDateFormat = DateTimeFormatter.ofPattern(region.getFormatPattern(XmlRegionalSettings.Region.FormatPattern.FormatType.LONG_DATE), region.getLocale());
        this.shortDatetimeFormat = DateTimeFormatter.ofPattern(region.getFormatPattern(XmlRegionalSettings.Region.FormatPattern.FormatType.SHORT_DATETIME), region.getLocale());
        this.mediumDatetimeFormat = DateTimeFormatter.ofPattern(region.getFormatPattern(XmlRegionalSettings.Region.FormatPattern.FormatType.MEDIUM_DATETIME), region.getLocale());
        this.longDatetimeFormat = DateTimeFormatter.ofPattern(region.getFormatPattern(XmlRegionalSettings.Region.FormatPattern.FormatType.LONG_DATETIME), region.getLocale());
        this.timeFormat = DateTimeFormatter.ofPattern(region.getFormatPattern(XmlRegionalSettings.Region.FormatPattern.FormatType.TIME), region.getLocale());
        this.fileDateFormat = DateTimeFormatter.ofPattern(region.getFormatPattern(XmlRegionalSettings.Region.FormatPattern.FormatType.FILE_DATE), region.getLocale());
        this.numberFormat = region.createDecimalFormat(region.getFormatPattern(XmlRegionalSettings.Region.FormatPattern.FormatType.NUMBER));
        this.percentFormat = FormatterRegionSettings.createPercentFormat(region);
        this.numberDurationFormat = region.createDecimalFormat(region.getFormatPattern(XmlRegionalSettings.Region.FormatPattern.FormatType.NUMBER_DURATION));
        this.symbols = region.getSymbols();
        this.d3I18nJSON = this.createD3I18nJSON(region);
        this.duDatePickerI18nJSON = this.createDuDatePickerI18nJSON(region);
        this.mediumDateFormatPattern = region.getFormatPattern(XmlRegionalSettings.Region.FormatPattern.FormatType.MEDIUM_DATE);
        this.shortDatetimeFormatPattern = region.getFormatPattern(XmlRegionalSettings.Region.FormatPattern.FormatType.SHORT_DATETIME);
        this.longDateTimeFormatPattern = region.getFormatPattern(XmlRegionalSettings.Region.FormatPattern.FormatType.LONG_DATETIME);
        this.decimalSeparator = region.getDecimalSeparator();
    }

    @Nonnull
    private static DecimalFormat createPercentFormat(XmlRegionalSettings.Region region) {
        String pattern = region.getFormatPattern(XmlRegionalSettings.Region.FormatPattern.FormatType.PERCENT);
        DecimalFormat f = region.createDecimalFormat(pattern);
        f.setMultiplier(100);
        f.setRoundingMode(RoundingMode.HALF_UP);
        return f;
    }

    public DateTimeFormatter getShortDateFormat() {
        return this.shortDateFormat;
    }

    public DateTimeFormatter getMediumDateFormat() {
        return this.mediumDateFormat;
    }

    public DateTimeFormatter getLongDateFormat() {
        return this.longDateFormat;
    }

    public DateTimeFormatter getMediumDatetimeFormat() {
        return this.mediumDatetimeFormat;
    }

    public String getMediumDateFormatPattern() {
        return this.mediumDateFormatPattern;
    }

    public DateTimeFormatter getShortDatetimeFormat() {
        return this.shortDatetimeFormat;
    }

    public String getShortDatetimeFormatPattern() {
        return this.shortDatetimeFormatPattern;
    }

    public DateTimeFormatter getLongDatetimeFormat() {
        return this.longDatetimeFormat;
    }

    public String getLongDateTimeFormatPattern() {
        return this.longDateTimeFormatPattern;
    }

    public DateTimeFormatter getTimeFormat() {
        return this.timeFormat;
    }

    public DateTimeFormatter getFileDateFormat() {
        return this.fileDateFormat;
    }

    public DecimalFormat getNumberFormat() {
        return this.numberFormat;
    }

    public DecimalFormat getPercentFormat() {
        return this.percentFormat;
    }

    public DecimalFormat getNumberDurationFormat() {
        return this.numberDurationFormat;
    }

    public XmlRegionalSettings.Region.Symbols getSymbols() {
        return this.symbols;
    }

    @Nonnull
    public DateTimeFormatter getUserDatetimeFormat(String pattern) {
        DateTimeFormatter format = this.userDateFormat.get(pattern);
        if (format == null) {
            format = DateTimeFormatter.ofPattern(pattern);
            this.userDateFormat.put(pattern, format);
        }
        return format;
    }

    @Nonnull
    public String getDuDatePickerI18nJSON() {
        return this.duDatePickerI18nJSON;
    }

    @Nonnull
    public String createDuDatePickerI18nJSON(XmlRegionalSettings.Region region) {
        Locale locale = region.getLocale();
        DuDatePickerI18n duDatePickerI18n = new DuDatePickerI18n(this.getMonths(locale), this.getShortMonths(locale), this.getDays(locale), this.getShortDays(locale), this.getShortDays(locale), region.getFirstDayOfWeek() == XmlRegionalSettings.Region.FirstDayOfWeek.MONDAY ? 1 : 7);
        try {
            return objectMapper.writeValueAsString(duDatePickerI18n);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public String getD3I18nJSON() {
        return this.d3I18nJSON;
    }

    private String createD3I18nJSON(@Nonnull XmlRegionalSettings.Region region) {
        XmlRegionalSettings.Region.D3 d3 = region.getD3();
        Locale locale = region.getLocale();
        D3I18n d3I18n = new D3I18n(StrftimePatternConverter.javaToStrftime(region.getFormatPattern(XmlRegionalSettings.Region.FormatPattern.FormatType.LONG_DATETIME)), StrftimePatternConverter.javaToStrftime(region.getFormatPattern(XmlRegionalSettings.Region.FormatPattern.FormatType.SHORT_DATE)), StrftimePatternConverter.javaToStrftime(region.getFormatPattern(XmlRegionalSettings.Region.FormatPattern.FormatType.TIME)), this.getPeriods(locale), this.getDays(locale), this.getShortDays(locale), this.getMonths(locale), this.getShortMonths(locale), StrftimePatternConverter.javaToStrftime(d3.getFormatPattern(XmlRegionalSettings.Region.D3.FormatPattern.D3PatternType.MILLISECOND).getPattern()), StrftimePatternConverter.javaToStrftime(d3.getFormatPattern(XmlRegionalSettings.Region.D3.FormatPattern.D3PatternType.SECOND).getPattern()), StrftimePatternConverter.javaToStrftime(d3.getFormatPattern(XmlRegionalSettings.Region.D3.FormatPattern.D3PatternType.MINUTE).getPattern()), StrftimePatternConverter.javaToStrftime(d3.getFormatPattern(XmlRegionalSettings.Region.D3.FormatPattern.D3PatternType.HOUR).getPattern()), StrftimePatternConverter.javaToStrftime(d3.getFormatPattern(XmlRegionalSettings.Region.D3.FormatPattern.D3PatternType.DAY).getPattern()), StrftimePatternConverter.javaToStrftime(d3.getFormatPattern(XmlRegionalSettings.Region.D3.FormatPattern.D3PatternType.WEEK).getPattern()), StrftimePatternConverter.javaToStrftime(d3.getFormatPattern(XmlRegionalSettings.Region.D3.FormatPattern.D3PatternType.MONTH).getPattern()), StrftimePatternConverter.javaToStrftime(d3.getFormatPattern(XmlRegionalSettings.Region.D3.FormatPattern.D3PatternType.YEAR).getPattern()));
        try {
            return objectMapper.writeValueAsString(d3I18n);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> getShortMonths(Locale locale) {
        return List.of(Month.JANUARY.getDisplayName(TextStyle.SHORT, locale), Month.FEBRUARY.getDisplayName(TextStyle.SHORT, locale), Month.MARCH.getDisplayName(TextStyle.SHORT, locale), Month.APRIL.getDisplayName(TextStyle.SHORT, locale), Month.MAY.getDisplayName(TextStyle.SHORT, locale), Month.JUNE.getDisplayName(TextStyle.SHORT, locale), Month.JULY.getDisplayName(TextStyle.SHORT, locale), Month.AUGUST.getDisplayName(TextStyle.SHORT, locale), Month.SEPTEMBER.getDisplayName(TextStyle.SHORT, locale), Month.OCTOBER.getDisplayName(TextStyle.SHORT, locale), Month.NOVEMBER.getDisplayName(TextStyle.SHORT, locale), Month.DECEMBER.getDisplayName(TextStyle.SHORT, locale));
    }

    private List<String> getMonths(Locale locale) {
        return List.of(Month.JANUARY.getDisplayName(TextStyle.FULL_STANDALONE, locale), Month.FEBRUARY.getDisplayName(TextStyle.FULL_STANDALONE, locale), Month.MARCH.getDisplayName(TextStyle.FULL_STANDALONE, locale), Month.APRIL.getDisplayName(TextStyle.FULL_STANDALONE, locale), Month.MAY.getDisplayName(TextStyle.FULL_STANDALONE, locale), Month.JUNE.getDisplayName(TextStyle.FULL_STANDALONE, locale), Month.JULY.getDisplayName(TextStyle.FULL_STANDALONE, locale), Month.AUGUST.getDisplayName(TextStyle.FULL_STANDALONE, locale), Month.SEPTEMBER.getDisplayName(TextStyle.FULL_STANDALONE, locale), Month.OCTOBER.getDisplayName(TextStyle.FULL_STANDALONE, locale), Month.NOVEMBER.getDisplayName(TextStyle.FULL_STANDALONE, locale), Month.DECEMBER.getDisplayName(TextStyle.FULL_STANDALONE, locale));
    }

    private List<String> getShortDays(Locale locale) {
        return List.of(DayOfWeek.SUNDAY.getDisplayName(TextStyle.SHORT, locale), DayOfWeek.MONDAY.getDisplayName(TextStyle.SHORT, locale), DayOfWeek.TUESDAY.getDisplayName(TextStyle.SHORT, locale), DayOfWeek.WEDNESDAY.getDisplayName(TextStyle.SHORT, locale), DayOfWeek.THURSDAY.getDisplayName(TextStyle.SHORT, locale), DayOfWeek.FRIDAY.getDisplayName(TextStyle.SHORT, locale), DayOfWeek.SATURDAY.getDisplayName(TextStyle.SHORT, locale));
    }

    private List<String> getDays(Locale locale) {
        return List.of(DayOfWeek.SUNDAY.getDisplayName(TextStyle.FULL, locale), DayOfWeek.MONDAY.getDisplayName(TextStyle.FULL, locale), DayOfWeek.TUESDAY.getDisplayName(TextStyle.FULL, locale), DayOfWeek.WEDNESDAY.getDisplayName(TextStyle.FULL, locale), DayOfWeek.THURSDAY.getDisplayName(TextStyle.FULL, locale), DayOfWeek.FRIDAY.getDisplayName(TextStyle.FULL, locale), DayOfWeek.SATURDAY.getDisplayName(TextStyle.FULL, locale));
    }

    private List<String> getPeriods(Locale locale) {
        String[] amPmStrings = new DateFormatSymbols(locale).getAmPmStrings();
        return List.of(amPmStrings[0], amPmStrings[1]);
    }

    private record DuDatePickerI18n(List<String> months, List<String> shortMonths, List<String> days, List<String> shortDays, List<String> shorterDays, int firstDay) {
    }

    public record D3I18n(String dateTime, String date, String time, List<String> periods, List<String> days, List<String> shortDays, List<String> months, List<String> shortMonths, String formatMillisecond, String formatSecond, String formatMinute, String formatHour, String formatDay, String formatWeek, String formatMonth, String formatYear) {
    }
}

